package simpleTypes;

import java.util.Scanner;

public class SumExample2 {
	
	public static void main(String[] args) {

		// The Scanner class can be used to "read" data from a file or a string
		Scanner in = new Scanner("123");
		if (in.hasNextInt()) {
			System.out.println("Scanned int = " + in.nextInt());
		} else {
			System.out.println("No int can be read!");
		}

		in = new Scanner("ABC123");
		if (in.hasNextInt()) {
			System.out.println("Scanned int = " + in.nextInt());
		} else {
			System.out.println("No int can be read!");
		}
		
		// Forgetting to check "hasNext..." can be fatal!
		in = new Scanner("ABC123");
		System.out.println("Scanned int = " + in.nextInt());
		// This raises a runtime error!
		
		/*
		 * From a type theoretic point of view the programming interface
		 *   boolean hasNextInt() and
		 *   int     nextInt()
		 * is simply wrong.
		 * 
		 * Having both these functions is similar to having a pair 
		 * of type (boolean * int), which is not what we want to model.
		 * 
		 * The "right" type for this would be a sum type, as in (pseudo-code)
		 *   (unit + int) nextInt()
		 * where unit is the final type (1).
		 * 
		 * With such type, we would be able to call nextInt(), and the return
		 * value would tell us:
		 *   1) whether the int can be read successfully or not
		 *   2) ONLY in the case it can be read, what s the int 
		 *    
		 * Because Scanner uses the wrong type, it must resort to runtime errors
		 * in some cases, and the burden is on the programmer to avoid those cases.
		 * Instead, the variant with a sum type would never cause errors!
		 * 
		 */
		
	}
}
